---
generated_at: 2026-01-21 10:30:00
metrics:
  claims_total: 14
  claims_with_evidence: 13
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：5-Show task dialog.ps1.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：13 / 14、根拠なし：1
- 優先レビュー（高）
  1. **TaskDialogクラスの詳細仕様**：StaxRip本体コードの確認が必要
  2. **キャンセル時の戻り値**：null/空文字列等の仕様確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/Scripts/Show task dialog.ps1` 行1-16（スクリプト全体）
- E-02: `Source/Scripts/Show task dialog.ps1` 行2-3（TaskDialog作成・タイトル設定）
- E-03: `Source/Scripts/Show task dialog.ps1` 行4-5（コマンド追加）
- E-04: `Source/Scripts/Show task dialog.ps1` 行6-7（ダイアログ表示・Dispose）
- E-05: `Source/Scripts/Show task dialog.ps1` 行9-15（結果判定・メッセージ表示）
- E-06: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` 行6

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | TaskDialog[string]を使用してダイアログを作成 | E-02 | ○ |
| C-02 | タイトルを"Select a option."に設定 | E-02 | ○ |
| C-03 | AddCommandでOption Aを追加（戻り値'aaa'） | E-03 | ○ |
| C-04 | AddCommandでOption Bを追加（戻り値'bbb'） | E-03 | ○ |
| C-05 | Show()メソッドで表示し結果を取得 | E-04 | ○ |
| C-06 | Dispose()でリソースを解放 | E-04 | ○ |
| C-07 | 'aaa'選択時に"Option A was selected."を表示 | E-05 | ○ |
| C-08 | 'bbb'選択時に"Option B was selected."を表示 | E-05 | ○ |
| C-09 | それ以外の場合"No option was selected."を表示 | E-05 | ○ |
| C-10 | MainModule.MsgInfoでメッセージを表示 | E-05 | ○ |
| C-11 | サンプルスクリプトである | E-06 | ○ |
| C-12 | StaxRipアプリ内から実行される | E-06 | ○ |
| C-13 | ジェネリック型TaskDialog[string]を使用 | E-02 | ○ |
| C-14 | キャンセル時の戻り値はnullまたは空 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- キャンセル時の戻り値の詳細：スクリプトの条件分岐から'aaa'でも'bbb'でもない場合をキャンセルと推測していますが、実際の戻り値（null、空文字列、特定の文字列等）はStaxRip本体のTaskDialogクラス実装を確認する必要があります
  - 候補：StaxRip本体のTaskDialogクラス定義 / StaxRipのスクリプティングAPIドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ダイアログ表示のみの単純なサンプルスクリプト
- 0: 低リスク - ファイルやデータへの変更を行わない

## 6) レビュアーチェックリスト（最小）
- [ ] TaskDialogの表示が期待通りか確認（StaxRip内での実行テスト）
- [ ] キャンセル時の動作が期待通りか確認
- [ ] Dispose()が適切にリソースを解放しているか確認
